package com.example.sefinsa_app.controllers;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.util.Log;

import com.example.sefinsa_app.migrations.DatabaseHelper;
import com.example.sefinsa_app.models.Gastos;
import com.example.sefinsa_app.models.ReporteDiarioDeRutas;

import java.util.ArrayList;

public class GastosController {

    private final DatabaseHelper databaseHelper;

    private final String NOMBRE_TABLA = "gastos";

    public GastosController(Context contexto) {
        databaseHelper = new DatabaseHelper(contexto);
        SQLiteDatabase db = databaseHelper.getWritableDatabase();

        String TABLE_SCHEMA = String.format("CREATE TABLE IF NOT EXISTS %s(" +
                        "id INTEGER PRIMARY KEY, " +
                        "otros TEXT, " +
                        "gasolina TEXT, " +
                        "hotel TEXT, " +
                        "alimentos TEXT, " +
                        "casetas TEXT, " +
                        "total TEXT, " +
                        "status TEXT DEFAULT '0')"
                , NOMBRE_TABLA);

        db.execSQL(TABLE_SCHEMA);
    }

    public void truncate(){
        SQLiteDatabase db = databaseHelper.getWritableDatabase();

        String TABLE_SCHEMA = String.format("CREATE TABLE IF NOT EXISTS %s(" +
                        "id INTEGER PRIMARY KEY, " +
                        "otros TEXT, " +
                        "gasolina TEXT, " +
                        "hotel TEXT, " +
                        "alimentos TEXT, " +
                        "casetas TEXT, " +
                        "total TEXT, " +
                        "status TEXT DEFAULT '0')"
                , NOMBRE_TABLA);

        db.execSQL("DROP TABLE IF EXISTS " + NOMBRE_TABLA);

        db.execSQL(TABLE_SCHEMA);

        Log.d("TRUNCATE",NOMBRE_TABLA);
    }

    public int eliminar(Gastos gastos) {

        SQLiteDatabase db = databaseHelper.getWritableDatabase();
        String[] argumentos = {String.valueOf(gastos.getId())};
        return db.delete(NOMBRE_TABLA, "id = ?", argumentos);
    }

    public long nueva(ReporteDiarioDeRutas reportediarioderutas) {

        SQLiteDatabase db = databaseHelper.getWritableDatabase();
        ContentValues valoresParaInsertar = new ContentValues();
        valoresParaInsertar.put("id", reportediarioderutas.getId());
        valoresParaInsertar.put("otros", reportediarioderutas.getPoblacion_id());
        valoresParaInsertar.put("gasolina", reportediarioderutas.getEstimacion());
        valoresParaInsertar.put("hotel", reportediarioderutas.getAbonos_semana());
        valoresParaInsertar.put("alimentos", reportediarioderutas.getRecuperacion_semana());
        valoresParaInsertar.put("casetas", reportediarioderutas.getRecuperacion_vencida());
        valoresParaInsertar.put("total", reportediarioderutas.getAnticipos());

        return db.insert(NOMBRE_TABLA, null, valoresParaInsertar);
    }

    public ArrayList<Gastos> obtener() {

        ArrayList<Gastos> gastos = new ArrayList<>();
        SQLiteDatabase db = databaseHelper.getReadableDatabase();

        String query = "SELECT * FROM gastos";
        Cursor cursor = db.rawQuery(query, null);

        if (cursor == null) {
            return gastos;
        }
        if (!cursor.moveToFirst()) return gastos;

        do {
            String id2 = cursor.getString(0);
            String otros = cursor.getString(1);
            String gasolina = cursor.getString(2);
            String hotel = cursor.getString(3);
            String alimentos = cursor.getString(4);
            String casetas = cursor.getString(5);
            String total_1 = cursor.getString(6);
            String status = cursor.getString(7);

            Gastos gastosObtenidoDeBD = new Gastos(id2, otros, gasolina, hotel, alimentos,casetas,
                    total_1, status);

            gastos.add(gastosObtenidoDeBD);

        } while (cursor.moveToNext());

        cursor.close();
        return gastos;
    }
}
